function applyVolumeToAll(vol) {
	const v = Number(vol);
	document.querySelectorAll('audio, video').forEach(el => {
		try { el.volume = isNaN(v) ? 1 : v; } catch(e) {}
	});
}

function applyPlaybackRateToAll(rate) {
	const r = Number(rate);
	document.querySelectorAll('audio, video').forEach(el => {
		try { el.playbackRate = isNaN(r) ? 1 : r; } catch(e) {}
	});
}

function getSavedPlaybackRate() {
	const saved = JSON.parse(localStorage.getItem('gridPlayerColors') || 'null') || {};
	return Number(saved.speed ?? saved.playbackRate ?? 1);
}

function getLabelFromAudioEl(a) {
	if (!a) return 'Audio';
	const id = a.id || '';
	const map = { audio1:'Benetti', audio2:'Davis', audio3:'Flemming', audio4:'Goodman', audio5:'Hamilton', audio6:'Kay', audio7:'Orsillo', audio8:'Scully', audio9:'Stone', audio10:'Uecker' };
	if (map[id]) return map[id];
	if (a.currentSrc) return a.currentSrc.split('/').pop();
	return id || 'Audio';
}

function updateLastPlayedRecord(id, label) {
	const lastEl = document.getElementById('lastPlayed');
	const now = new Date().toLocaleString();
	const record = { id: id || '', label: label || '', time: now };
	const saved = JSON.parse(localStorage.getItem('gridPlayerColors') || 'null') || {};
	saved.lastPlayed = record;
	localStorage.setItem('gridPlayerColors', JSON.stringify(saved));
	if (lastEl) lastEl.textContent = `Last played: ${record.label} — ${record.time}`;
}

function firstButton() {
	const status = document.getElementById('playerStatus');
	const a = document.getElementById('audio1');
	if (!a) {
		if (status) status.textContent = 'No audio source found.';
		return console.warn('audio1 element not found');
	}

	
	if (!a.paused && !a.ended) {
		a.pause();
		if (status) status.textContent = 'Paused';
		return;
	}

	
	a.play().then(() => {
		console.log('Audio element started playing');
		if (status) status.textContent = 'Playing';
		updateLastPlayedRecord(a.id, getLabelFromAudioEl(a));
	}).catch(err => {
		console.warn('Audio element failed, attempting fallback to video:', err);
		
		let v = document.getElementById('video1');
		if (!v) {
			v = document.createElement('video');
			v.id = 'video1';
			v.style.display = 'none';
			v.src = document.getElementById('audio1src')?.src || a.src || '';
			try { v.playbackRate = getSavedPlaybackRate(); } catch(e) {}
			v.playsInline = true;
			document.body.appendChild(v);
		}

		if (!v.paused && !v.ended) {
			v.pause();
			if (status) status.textContent = 'Paused';
			return;
		}

		v.play().then(() => {
			console.log('Fallback video started playing');
			if (status) status.textContent = 'Playing audio (video fallback)';
			updateLastPlayedRecord(a.id, getLabelFromAudioEl(a));
		}).catch(e => {
			console.error('Fallback also failed', e);
			if (status) status.textContent = 'Playback failed (see console)';
		});
	});
}

function secondButton() {
	const status = document.getElementById('playerStatus');
	
	let a = document.getElementById('audio2');
	if (!a) {
		
		a = document.getElementById('audio1');
		if (status) status.textContent = 'Using primary audio source';
	}

	if (!a) {
		if (status) status.textContent = 'No audio source found.';
		return console.warn('no audio element found for secondButton');
	}

	
	if (!a.paused && !a.ended) {
		a.pause();
		if (status) status.textContent = 'Paused';
		return;
	}

	a.play().then(() => {
		if (status) status.textContent = 'Playing';
		console.log('Second audio started playing');
		updateLastPlayedRecord(a.id, getLabelFromAudioEl(a));
	}).catch(err => {
		console.warn('Second audio failed, attempting video fallback:', err);
		let v = document.getElementById('video2') || document.getElementById('video1');
		if (!v) {
			v = document.createElement('video');
			v.id = 'video2';
			v.style.display = 'none';
			
			v.src = document.getElementById('audio2src')?.src || document.getElementById('audio1src')?.src || a.src || '';
			try { v.playbackRate = getSavedPlaybackRate(); } catch(e) {}
			v.playsInline = true;
			document.body.appendChild(v);
		}

		if (!v.paused && !v.ended) {
			v.pause();
			if (status) status.textContent = 'Paused';
			return;
		}

		v.play().then(() => {
			if (status) status.textContent = 'Playing audio (video fallback)';
			console.log('Fallback video started for second button');
			updateLastPlayedRecord(a.id, getLabelFromAudioEl(a));
		}).catch(e => {
			console.error('Fallback failed for second button', e);
			if (status) status.textContent = 'Playback failed (see console)';
		});
	});
}

function thirdButton() {
	const status = document.getElementById('playerStatus');
	
	const a = document.getElementById('audio3') || document.getElementById('audio1');
	if (!a) {
		if (status) status.textContent = 'No audio source found.';
		return console.warn('no audio element found for thirdButton');
	}

	
	if (!a.paused && !a.ended) {
		a.pause();
		if (status) status.textContent = 'Paused';
		return;
	}

	
	a.play().then(() => {
		console.log('Audio element started playing');
		if (status) status.textContent = 'Playing';
		updateLastPlayedRecord(a.id, getLabelFromAudioEl(a));
	}).catch(err => {
		console.warn('Audio element failed, attempting fallback to video:', err);
		
		
		let v = document.getElementById('video3') || document.getElementById('video1');
		if (!v) {
			v = document.createElement('video');
			v.id = document.getElementById('video3') ? 'video3' : 'video1';
			v.style.display = 'none';
			v.src = document.getElementById('audio3src')?.src || document.getElementById('audio1src')?.src || a.src || '';
			try { v.playbackRate = getSavedPlaybackRate(); } catch(e) {}
			v.playsInline = true;
			document.body.appendChild(v);
		}

		if (!v.paused && !v.ended) {
			v.pause();
			if (status) status.textContent = 'Paused';
			return;
		}

		v.play().then(() => {
			console.log('Fallback video started playing');
			if (status) status.textContent = 'Playing audio (video fallback)';
			updateLastPlayedRecord(a.id, getLabelFromAudioEl(a));
		}).catch(e => {
			console.error('Fallback also failed', e);
			if (status) status.textContent = 'Playback failed (see console)';
		});
	});
}

function fourthButton() { 
	const status = document.getElementById('playerStatus');
	
	const a = document.getElementById('audio4') || document.getElementById('audio1');
	if (!a) {
		if (status) status.textContent = 'No audio source found.';
		return console.warn('no audio element found for fourthButton');
	}

	
	if (!a.paused && !a.ended) {
		a.pause();
		if (status) status.textContent = 'Paused';
		return;
	}

	
	a.play().then(() => {
		console.log('Audio element started playing');
		if (status) status.textContent = 'Playing';
		updateLastPlayedRecord(a.id, getLabelFromAudioEl(a));
	}).catch(err => {
		console.warn('Audio element failed, attempting fallback to video:', err);
		
		
		let v = document.getElementById('video4') || document.getElementById('video1');
		if (!v) {
			v = document.createElement('video');
			v.id = document.getElementById('video4') ? 'video4' : 'video1';
			v.style.display = 'none';
			v.src = document.getElementById('audio4src')?.src || document.getElementById('audio1src')?.src || a.src || '';
			try { v.playbackRate = getSavedPlaybackRate(); } catch(e) {}
			v.playsInline = true;
			document.body.appendChild(v);
		}

		if (!v.paused && !v.ended) {
			v.pause();
			if (status) status.textContent = 'Paused';
			return;
		}

		v.play().then(() => {
			console.log('Fallback video started playing');
			if (status) status.textContent = 'Playing audio (video fallback)';
			updateLastPlayedRecord(a.id, getLabelFromAudioEl(a));
		}).catch(e => {
			console.error('Fallback also failed', e);
			if (status) status.textContent = 'Playback failed (see console)';
		});
	});

}

function fifthButton() {
const status = document.getElementById('playerStatus');
	
	const a = document.getElementById('audio5') || document.getElementById('audio1');
	if (!a) {
		if (status) status.textContent = 'No audio source found.';
		return console.warn('no audio element found for fifthButton');
	}

	
	if (!a.paused && !a.ended) {
		a.pause();
		if (status) status.textContent = 'Paused';
		return;
	}

	
	a.play().then(() => {
		console.log('Audio element started playing');
		if (status) status.textContent = 'Playing';
		updateLastPlayedRecord(a.id, getLabelFromAudioEl(a));
	}).catch(err => {
		console.warn('Audio element failed, attempting fallback to video:', err);
		
		
		let v = document.getElementById('video5') || document.getElementById('video1');
		if (!v) {
			v = document.createElement('video');
			v.id = document.getElementById('video5') ? 'video5' : 'video1';
			v.style.display = 'none';
			v.src = document.getElementById('audio5src')?.src || document.getElementById('audio1src')?.src || a.src || '';
			try { v.playbackRate = getSavedPlaybackRate(); } catch(e) {}
			v.playsInline = true;
			document.body.appendChild(v);
		}

		if (!v.paused && !v.ended) {
			v.pause();
			if (status) status.textContent = 'Paused';
			return;
		}

		v.play().then(() => {
			console.log('Fallback video started playing');
			if (status) status.textContent = 'Playing audio (video fallback)';
			updateLastPlayedRecord(a.id, getLabelFromAudioEl(a));
		}).catch(e => {
			console.error('Fallback also failed', e);
			if (status) status.textContent = 'Playback failed (see console)';
		});
	});
}



function sixthButton() {
const status = document.getElementById('playerStatus');
	
	const a = document.getElementById('audio6') || document.getElementById('audio1');
	if (!a) {
		if (status) status.textContent = 'No audio source found.';
		return console.warn('no audio element found for sixthButton');
	}

	
	if (!a.paused && !a.ended) {
		a.pause();
		if (status) status.textContent = 'Paused';
		return;
	}

	
	a.play().then(() => {
		console.log('Audio element started playing');
		if (status) status.textContent = 'Playing';
		updateLastPlayedRecord(a.id, getLabelFromAudioEl(a));
	}).catch(err => {
		console.warn('Audio element failed, attempting fallback to video:', err);
		
		
		let v = document.getElementById('video6') || document.getElementById('video1');
		if (!v) {
			v = document.createElement('video');
			v.id = document.getElementById('video6') ? 'video6' : 'video1';
			v.style.display = 'none';
			v.src = document.getElementById('audio6src')?.src || document.getElementById('audio1src')?.src || a.src || '';
			try { v.playbackRate = getSavedPlaybackRate(); } catch(e) {}
			v.playsInline = true;
			document.body.appendChild(v);
		}

		if (!v.paused && !v.ended) {
			v.pause();
			if (status) status.textContent = 'Paused';
			return;
		}

		v.play().then(() => {
			console.log('Fallback video started playing');
			if (status) status.textContent = 'Playing audio (video fallback)';
		}).catch(e => {
			console.error('Fallback also failed', e);
			if (status) status.textContent = 'Playback failed (see console)';
		});
	});
}

function seventhButton() {
const status = document.getElementById('playerStatus');
	
	const a = document.getElementById('audio7') || document.getElementById('audio1');
	if (!a) {
		if (status) status.textContent = 'No audio source found.';
		return console.warn('no audio element found for seventhButton');
	}

	
	if (!a.paused && !a.ended) {
		a.pause();
		if (status) status.textContent = 'Paused';
		return;
	}

	
	a.play().then(() => {
		console.log('Audio element started playing');
		if (status) status.textContent = 'Playing';
		updateLastPlayedRecord(a.id, getLabelFromAudioEl(a));
	}).catch(err => {
		console.warn('Audio element failed, attempting fallback to video:', err);
		
		
		let v = document.getElementById('video7') || document.getElementById('video1');
		if (!v) {
			v = document.createElement('video');
			v.id = document.getElementById('video7') ? 'video7' : 'video1';
			v.style.display = 'none';
			v.src = document.getElementById('audio7src')?.src || document.getElementById('audio1src')?.src || a.src || '';
			try { v.playbackRate = getSavedPlaybackRate(); } catch(e) {}
			v.playsInline = true;
			document.body.appendChild(v);
		}

		if (!v.paused && !v.ended) {
			v.pause();
			if (status) status.textContent = 'Paused';
			return;
		}

		v.play().then(() => {
			console.log('Fallback video started playing');
			if (status) status.textContent = 'Playing audio (video fallback)';
		}).catch(e => {
			console.error('Fallback also failed', e);
			if (status) status.textContent = 'Playback failed (see console)';
		});
	});
}

function eighthButton() {
const status = document.getElementById('playerStatus');
	
	const a = document.getElementById('audio8') || document.getElementById('audio1');
	if (!a) {
		if (status) status.textContent = 'No audio source found.';
		return console.warn('no audio element found for eighthButton');
	}

	
	if (!a.paused && !a.ended) {
		a.pause();
		if (status) status.textContent = 'Paused';
		return;
	}

	
	a.play().then(() => {
		console.log('Audio element started playing');
		if (status) status.textContent = 'Playing';
		updateLastPlayedRecord(a.id, getLabelFromAudioEl(a));
	}).catch(err => {
		console.warn('Audio element failed, attempting fallback to video:', err);
		
		
		let v = document.getElementById('video8') || document.getElementById('video1');
		if (!v) {
			v = document.createElement('video');
			v.id = document.getElementById('video8') ? 'video8' : 'video1';
			v.style.display = 'none';
			v.src = document.getElementById('audio8src')?.src || document.getElementById('audio1src')?.src || a.src || '';
			try { v.playbackRate = getSavedPlaybackRate(); } catch(e) {}
			v.playsInline = true;
			document.body.appendChild(v);
		}

		if (!v.paused && !v.ended) {
			v.pause();
			if (status) status.textContent = 'Paused';
			return;
		}

		v.play().then(() => {
			console.log('Fallback video started playing');
			if (status) status.textContent = 'Playing audio (video fallback)';
		}).catch(e => {
			console.error('Fallback also failed', e);
			if (status) status.textContent = 'Playback failed (see console)';
		});
	});
}

function ninthButton() {
const status = document.getElementById('playerStatus');
	
	const a = document.getElementById('audio9') || document.getElementById('audio1');
	if (!a) {
		if (status) status.textContent = 'No audio source found.';
		return console.warn('no audio element found for ninthButton');
	}

	
	if (!a.paused && !a.ended) {
		a.pause();
		if (status) status.textContent = 'Paused';
		return;
	}

	
	a.play().then(() => {
		console.log('Audio element started playing');
		if (status) status.textContent = 'Playing';
		updateLastPlayedRecord(a.id, getLabelFromAudioEl(a));
	}).catch(err => {
		console.warn('Audio element failed, attempting fallback to video:', err);
		
		
		let v = document.getElementById('video9') || document.getElementById('video1');
		if (!v) {
			v = document.createElement('video');
			v.id = document.getElementById('video9') ? 'video9' : 'video1';
			v.style.display = 'none';
			v.src = document.getElementById('audio9src')?.src || document.getElementById('audio1src')?.src || a.src || '';
			try { v.playbackRate = getSavedPlaybackRate(); } catch(e) {}
			v.playsInline = true;
			document.body.appendChild(v);
		}

		if (!v.paused && !v.ended) {
			v.pause();
			if (status) status.textContent = 'Paused';
			return;
		}

		v.play().then(() => {
			console.log('Fallback video started playing');
			if (status) status.textContent = 'Playing audio (video fallback)';
		}).catch(e => {
			console.error('Fallback also failed', e);
			if (status) status.textContent = 'Playback failed (see console)';
		});
	});
}

function finalButton() {
const status = document.getElementById('playerStatus');
	
	const a = document.getElementById('audio10') || document.getElementById('audio1');
	if (!a) {
		if (status) status.textContent = 'No audio source found.';
		return console.warn('no audio element found for finalButton');
	}

	
	if (!a.paused && !a.ended) {
		a.pause();
		if (status) status.textContent = 'Paused';
		return;
	}

	
	a.play().then(() => {
		console.log('Audio element started playing');
		if (status) status.textContent = 'Playing';
		updateLastPlayedRecord(a.id, getLabelFromAudioEl(a));
	}).catch(err => {
		console.warn('Audio element failed, attempting fallback to video:', err);
		
		
		let v = document.getElementById('video10') || document.getElementById('video1');
		if (!v) {
			v = document.createElement('video');
			v.id = document.getElementById('video10') ? 'video10' : 'video1';
			v.style.display = 'none';
			v.src = document.getElementById('audio10src')?.src || document.getElementById('audio1src')?.src || a.src || '';
			try { v.playbackRate = getSavedPlaybackRate(); } catch(e) {}
			v.playsInline = true;
			document.body.appendChild(v);
		}

		if (!v.paused && !v.ended) {
			v.pause();
			if (status) status.textContent = 'Paused';
			return;
		}

		v.play().then(() => {
			console.log('Fallback video started playing');
			if (status) status.textContent = 'Playing audio (video fallback)';
		}).catch(e => {
			console.error('Fallback also failed', e);
			if (status) status.textContent = 'Playback failed (see console)';
		});
	});
}


document.addEventListener('DOMContentLoaded', () => {
	const bgInput = document.getElementById('bgColorInput');
	const panelInput = document.getElementById('panelColorInput');
	const nameInput = document.getElementById('userNameInput');
	const volumeInput = document.getElementById('volumeControl');
	const speedSelect = document.getElementById('speedControl');
	const saveBtn = document.getElementById('saveColorsBtn');
	const resetBtn = document.getElementById('resetColorsBtn');
	const greetingEl = document.getElementById('greeting');
	const lastEl = document.getElementById('lastPlayed');

	function applyColors(bg, panel) {
		document.documentElement.style.setProperty('--page-bg-start', bg);
		
		const end = shadeColor(bg, -6);
		document.documentElement.style.setProperty('--page-bg-end', end);
		document.documentElement.style.setProperty('--panel-bg', panel);
	}

	function shadeColor(hex, percent) {
		
		const f = hex.slice(1), t = percent < 0 ? 0 : 255, p = Math.abs(percent) / 100;
		const R = parseInt(f.substring(0,2),16), G = parseInt(f.substring(2,4),16), B = parseInt(f.substring(4,6),16);
		const newR = Math.round((t - R) * p) + R;
		const newG = Math.round((t - G) * p) + G;
		const newB = Math.round((t - B) * p) + B;
		return `#${(0x1000000 + (newR<<16) + (newG<<8) + newB).toString(16).slice(1)}`;
	}

	
	const saved = JSON.parse(localStorage.getItem('gridPlayerColors') || 'null') || {};
	if (saved.bg && saved.panel) {
		if (bgInput) bgInput.value = saved.bg;
		if (panelInput) panelInput.value = saved.panel;
		applyColors(saved.bg, saved.panel);
	}
	if (saved.name) {
		if (nameInput) nameInput.value = saved.name;
		if (greetingEl) greetingEl.textContent = `Welcome, ${saved.name}`;
	}
	if (typeof saved.volume !== 'undefined') {
		if (volumeInput) volumeInput.value = saved.volume;
		applyVolumeToAll(saved.volume);
	}
	const initialSpeed = getSavedPlaybackRate();
	if (speedSelect) {
		const matchOpt = Array.from(speedSelect.options).find(o => Number(o.value) === Number(initialSpeed));
		if (matchOpt) speedSelect.value = matchOpt.value;
		applyPlaybackRateToAll(initialSpeed);
	}
	if (saved.lastPlayed) {
		const r = saved.lastPlayed;
		if (lastEl) lastEl.textContent = `Last played: ${r.label} — ${r.time}`;
	}

	if (saveBtn) saveBtn.addEventListener('click', () => {
		const bg = bgInput?.value || getComputedStyle(document.documentElement).getPropertyValue('--page-bg-start').trim();
		const panel = panelInput?.value || getComputedStyle(document.documentElement).getPropertyValue('--panel-bg').trim();
		const name = nameInput?.value?.trim() || '';
		const volume = volumeInput?.value ?? 1;
		const speed = speedSelect?.value ?? getSavedPlaybackRate();
		const toSave = Object.assign({}, saved, { bg, panel, name, volume });
		toSave.speed = speed;
		localStorage.setItem('gridPlayerColors', JSON.stringify(toSave));
		applyColors(bg, panel);
		if (greetingEl) greetingEl.textContent = name ? `Welcome, ${name}` : '';
		applyVolumeToAll(volume);
		applyPlaybackRateToAll(speed);
	});

	if (resetBtn) resetBtn.addEventListener('click', () => {
		localStorage.removeItem('gridPlayerColors');
        
		applyColors('#f5f6f7', '#ffffff');
		if (bgInput) bgInput.value = '#f5f6f7';
		if (panelInput) panelInput.value = '#ffffff';
		if (nameInput) nameInput.value = '';
		if (greetingEl) greetingEl.textContent = '';
		if (volumeInput) volumeInput.value = 1;
		applyVolumeToAll(1);
		if (speedSelect) speedSelect.value = '1';
		applyPlaybackRateToAll(1);
		if (lastEl) lastEl.textContent = '';
	});

	if (volumeInput) volumeInput.addEventListener('input', (e) => {
		const v = e.target.value;
		applyVolumeToAll(v);
	});

	if (speedSelect) speedSelect.addEventListener('change', (e) => {
		const r = e.target.value;
		applyPlaybackRateToAll(r);
		const cur = JSON.parse(localStorage.getItem('gridPlayerColors') || 'null') || {};
		cur.speed = r;
		localStorage.setItem('gridPlayerColors', JSON.stringify(cur));
	});

	const panel = document.getElementById('colorSettings');
	const hideBtn = document.getElementById('hidePanelBtn') || document.getElementById('toggleThemeBtn');
	const showBtn = document.getElementById('showPanelBtn') || document.getElementById('showThemeBtn');

	function showPanel() {
		if (!panel) return;
		panel.classList.remove('cs-hidden');
		if (showBtn) showBtn.style.display = 'none';
		if (hideBtn) hideBtn.style.display = 'inline-block';
	}

	function hidePanel() {
		if (!panel) return;
		panel.classList.add('cs-hidden');
		if (showBtn) showBtn.style.display = 'block';
		if (hideBtn) hideBtn.style.display = 'none';
	}

	if (hideBtn) hideBtn.addEventListener('click', hidePanel);
	if (showBtn) showBtn.addEventListener('click', showPanel);

});
